package ru.yandex.chemodan.queller.celery.job;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.queller.celery.CeleryBender;
import ru.yandex.chemodan.queller.celery.worker.WorkerId;
import ru.yandex.chemodan.util.bender.BenderUtils;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderDefaultValue;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class CeleryJobContext extends DefaultObject {
    @BenderDefaultValue("false")
    public final boolean globalQueued;

    public final Option<Instant> created;
    public final Option<Instant> scheduled;
    public final Option<String> activeUid;

    public final Option<String> ycrid;
    public final Option<String> host;

    public final Option<WorkerId> worker;
    public final Option<Instant> started;
    public final Option<Instant> finished;

    public final Option<String> error;
    public final Option<String> traceback;

    public final Option<Integer> maxRetries;

    public CeleryJobContext(
            boolean globalQueued,
            Option<Instant> created, Option<Instant> scheduled,
            Option<String> activeUid,
            Option<String> ycrid, Option<String> host,
            Option<WorkerId> worker,
            Option<Instant> started, Option<Instant> finished,
            Option<String> error, Option<String> traceback, Option<Integer> maxRetries)
    {
        this.globalQueued = globalQueued;
        this.created = created;
        this.scheduled = scheduled;
        this.activeUid = activeUid;
        this.ycrid = ycrid;
        this.host = host;
        this.worker = worker;
        this.started = started;
        this.finished = finished;
        this.error = error;
        this.traceback = traceback;
        this.maxRetries = maxRetries;
    }

    public static CeleryJobContext empty() {
        return new CeleryJobContext(
                false, Option.empty(), Option.empty(), Option.empty(), Option.empty(), Option.empty(),
                Option.empty(), Option.empty(), Option.empty(), Option.empty(), Option.empty(), Option.empty());
    }

    public CeleryJobContext reducedForSubmit() {
        return new CeleryJobContext(
                globalQueued, created, scheduled, activeUid, ycrid, host,
                Option.empty(), Option.empty(), Option.empty(), Option.empty(), Option.empty(), maxRetries);
    }

    public CeleryJobContext withMaxRetries(int maxRetries) {
        return new CeleryJobContext(
                globalQueued, created, scheduled, activeUid, ycrid, host,
                worker, started, finished, error, traceback, Option.of(maxRetries));
    }

    public JsonObject toJson() {
        return BenderUtils.toJsonObject(CeleryBender.mapper.createSerializer(CeleryJobContext.class), this);
    }

    public static CeleryJobContext fromJson(JsonObject object) {
        return BenderUtils.fromJsonObject(CeleryBender.mapper.createParser(CeleryJobContext.class), object);
    }
}
