package ru.yandex.chemodan.queller.celery.job;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicyWithAttempts;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class CeleryTask {

    public final TaskId id;
    public final String executionQueue;
    public final int priority;

    public final Option<Duration> softTimeout;
    public final Option<Duration> hardTimeout;
    public final ReschedulePolicy reschedulePolicy;
    public final ActiveUidBehavior activeUidBehavior;

    public CeleryTask(
            TaskId id, String executionQueue, int priority,
            Option<Duration> softTimeout, Option<Duration> hardTimeout,
            ReschedulePolicy reschedulePolicy, ActiveUidBehavior activeUidBehavior)
    {
        this.id = id;
        this.executionQueue = executionQueue;
        this.priority = priority;
        this.softTimeout = softTimeout;
        this.hardTimeout = hardTimeout;
        this.reschedulePolicy = reschedulePolicy;
        this.activeUidBehavior = activeUidBehavior;
    }

    public CeleryTask withQueueName(String queueName) {
        return new CeleryTask(id, queueName, priority, softTimeout, hardTimeout, reschedulePolicy, activeUidBehavior);
    }

    public int getMaxRetires() {
        if (reschedulePolicy instanceof ReschedulePolicyWithAttempts) {
            return ((ReschedulePolicyWithAttempts) reschedulePolicy).getAttemptCount();
        }
        return 0;
    }
}
