package ru.yandex.chemodan.queller.celery.monitoring;

import ru.yandex.misc.monica.annotation.GroupByDefault;
import ru.yandex.misc.monica.annotation.MonicaContainer;
import ru.yandex.misc.monica.annotation.MonicaMetric;
import ru.yandex.misc.monica.core.blocks.Health;
import ru.yandex.misc.monica.core.blocks.InstrumentMap;
import ru.yandex.misc.monica.core.blocks.MeterMap;
import ru.yandex.misc.monica.core.blocks.ValueMap;
import ru.yandex.misc.monica.core.name.MetricGroupName;
import ru.yandex.misc.monica.core.name.MetricName;

/**
 * @author yashunsky
 */
public class CeleryMetrics implements MonicaContainer {

    @MonicaMetric(description = "Connection to RabbitMQ pool")
    @GroupByDefault
    public final ValueMap<Health> connectedToRabbits = new ValueMap<>(Health.class);

    //Metrics from CeleryMonitor

    @MonicaMetric(description = "Workers processes")
    @GroupByDefault
    public final ValueMap<Integer> processes = new ValueMap<>(Integer.class);

    @MonicaMetric(description = "Is worker consuming tasks from queue")
    @GroupByDefault
    public final ValueMap<Boolean> isConsuming = new ValueMap<>(Boolean.class);

    @MonicaMetric(description = "Replies from Celery")
    @GroupByDefault
    public final InstrumentMap replies = new InstrumentMap();

    @MonicaMetric(description = "Requests to Celery")
    @GroupByDefault
    public final MeterMap requests = new MeterMap();

    @MonicaMetric(description = "Queues message and consumer counts")
    @GroupByDefault
    public final ValueMap<Integer> queuesStates = new ValueMap<>(Integer.class);

    //Metrics from CeleryExecutionQueues
    @MonicaMetric(description = "Execution queues message count")
    @GroupByDefault
    public final ValueMap<Integer> executionQueuesMessageCount = new ValueMap<>(Integer.class);

    @MonicaMetric(description = "Execution queues consumer count")
    @GroupByDefault
    public final ValueMap<Integer> executionQueuesConsumerCount = new ValueMap<>(Integer.class);


    @MonicaMetric(description = "Tasks")
    @GroupByDefault
    public final MeterMap tasks = new MeterMap();

    @MonicaMetric(description = "Completed tasks")
    @GroupByDefault
    public final InstrumentMap tasksDone = new InstrumentMap();

    @MonicaMetric(description = "Statuses of sending task messages")
    @GroupByDefault
    public final MeterMap tasksSending = new MeterMap();

    @Override
    public MetricGroupName groupName(String instanceName) {
        return new MetricGroupName("celery", new MetricName("celery"), "celery workers control");
    }
}
