package ru.yandex.chemodan.queller.celery.worker;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Try;
import ru.yandex.bolts.function.forhuman.Comparator;
import ru.yandex.misc.algo.AlphanumericComparator;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderTextValue;
import ru.yandex.misc.ip.Host;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author dbrylev
 */
@Bendable
public class WorkerId extends DefaultObject {

    public static final Comparator<WorkerId> comparator = Comparator.<WorkerId>constEqualComparator()
            .thenComparing(Comparator.wrap(AlphanumericComparator.SENSITIVE)
                    .<WorkerId>compose(w -> w.host.map(Host::format).getOrElse("")))
            .thenComparing(Comparator.wrap(AlphanumericComparator.SENSITIVE)
                    .<WorkerId>compose(w -> w.name.name));

    public final WorkerName name;
    public final Option<Host> host;

    public WorkerId(WorkerName name, Option<Host> host) {
        this.name = name;
        this.host = host;
    }

    @BenderTextValue
    public static WorkerId parse(String id) {
        int atIdx = id.indexOf('@');
        Option<Host> host = Option.empty();

        if (atIdx > 0) {
            host = Try.tryCatchException(() -> Host.parse(id.substring(atIdx + 1))).toOption();
        }
        return host.isPresent()
                ? new WorkerId(new WorkerName(id.substring(0, atIdx)), host)
                : new WorkerId(new WorkerName(id), host);
    }

    @Override
    public String toString() {
        return Option.of(name.name).plus(host.map(Host::format)).mkString("@");
    }

    @BenderTextValue
    public String serialize() {
        return toString();
    }
}
