package ru.yandex.chemodan.queller.celery.worker;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.type.MonoidPlus;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author yashunsky
 */
@BenderBindAllFields
public class WorkerState extends DefaultObject {
    //Statistics entry is created when a reply is received
    public Instant lastAnswer;

    public String workerId;
    public boolean isJavaWorker;

    public ListF<String> rabbitHosts = Cf.list();
    public Option<Integer> poolSize = Option.empty(); // current target processes got from Celery
    public Option<Integer> processesCount = Option.empty(); //real number of processes. Approaches poolSize
    public Option<Integer> activeProcessesCount = Option.empty();
    public Option<Boolean> isConsuming = Option.empty();
    public ListF<String> queues = Option.empty(); // active queues

    public Aggregated aggregated() {
        return isConsuming.isSome(true)
                ? new Aggregated(poolSize.getOrElse(0), processesCount.getOrElse(0), activeProcessesCount.getOrElse(0))
                : Aggregated.EMPTY;
    }

    @AllArgsConstructor
    @Getter
    public static class Aggregated extends DefaultObject {
        private final int poolSize;
        private final int processesCount;
        private final int activeProcessesCount;

        public static final Aggregated EMPTY = new Aggregated(0, 0, 0);
        public static final Adder ADDER = new Adder();

        public Aggregated plus(Aggregated b) {
            return new Aggregated(
                    poolSize + b.poolSize,
                    processesCount + b.processesCount,
                    activeProcessesCount + b.activeProcessesCount);
        }
    }

    public static class Adder implements MonoidPlus<Aggregated> {

        @Override
        public Aggregated zero() {
            return Aggregated.EMPTY;
        }

        @Override
        public Aggregated plus(Aggregated a, Aggregated b) {
            return a.plus(b);
        }
    }
}
