package ru.yandex.chemodan.queller.rabbit;

import javax.annotation.PreDestroy;

import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Queue;

import ru.yandex.bolts.collection.ListF;

/**
 * @author yashunsky
 */
public class PoolListener {

    private final ListF<ConnectedListener> listeners;

    public PoolListener(ListF<RabbitConnection> rabbitConnections) {
        listeners = rabbitConnections.map(ConnectedListener::new);
    }

    public final void setExclusive(boolean exclusive) {
        listeners.forEach(l -> l.setExclusive(exclusive));
    }

    public void setQueues(Queue... queues) {
        listeners.forEach(l -> l.setQueues(queues));
    }

    public void setConcurrentConsumers(final int concurrentConsumers) {
        listeners.forEach(l -> l.setConcurrentConsumers(concurrentConsumers));
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        listeners.forEach(l -> l.setMaxConcurrentConsumers(maxConcurrentConsumers));
    }

    public void setPrefetchCount(int prefetchCount) {
        listeners.forEach(l -> l.setPrefetchCount(prefetchCount));
    }

    public void setTxSize(int txSize) {
        listeners.forEach(l -> l.setTxSize(txSize));
    }

    public void setReceiveTimeout(long receiveTimeoutMs) {
        listeners.forEach(l -> l.setReceiveTimeout(receiveTimeoutMs));
    }

    public void setMessageListener(Object messageListener) {
        listeners.forEach(l -> l.setMessageListener(messageListener));
    }

    public void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
        listeners.forEach(l -> l.setAcknowledgeMode(acknowledgeMode));
    }

    public void start() {
        listeners.forEach(ConnectedListener::start);
    }

    public void startIfNotRunning() {
        listeners.forEach(ConnectedListener::startIfNotRunning);
    }

    public void stop() {
        listeners.forEach(ConnectedListener::stop);
    }

    public void maintain() {
        listeners.forEach(ConnectedListener::start);
    }

    @PreDestroy
    public void destroy() {
        stop();
    }
}
