package ru.yandex.chemodan.queller.rabbit;

import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.ip.Host;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author yashunsky
 */

@BenderBindAllFields
public class RabbitConnectionHealth extends DefaultObject {
    public final String host;
    public final boolean isActive;
    public final boolean isConnected;
    public final boolean readyToReceive;
    public final double sendingRate;
    public final CheckedValue sendingErrorRate;
    public final CheckedValue sendingDuration;
    public final CheckedValue pingTimeoutPerMinute;
    public final CheckedValue pingDuration;

    public final boolean isHealthy;

    public final boolean canBeUsed;

    @BenderBindAllFields
    public static class CheckedValue extends DefaultObject {
        public final double value;
        public final boolean isOk;

        public CheckedValue(double value, boolean isOk) {
            this.value = value;
            this.isOk = isOk;
        }
    }

    public RabbitConnectionHealth(Host host, boolean isActive,
            boolean isConnected, boolean readyToReceive, boolean forceUse,
            double sendingRate, double sendingErrorRate,
            double sendingDuration,
            double pingTimeoutPerMinute, double pingDuration,
            double maxSendingErrorRate, double maxSendingDuration,
            double maxPingTimeoutPerMinute,
            double maxPingDuration,
            double minSignificantRps)
    {
        this.host = host.toString();
        this.isActive = isActive;
        this.isConnected = isConnected;
        this.readyToReceive = readyToReceive;
        this.sendingRate = sendingRate;
        this.sendingErrorRate = new CheckedValue(sendingErrorRate, sendingErrorRate < maxSendingErrorRate);
        this.sendingDuration = new CheckedValue(sendingDuration, sendingDuration < maxSendingDuration);
        this.pingTimeoutPerMinute =
                new CheckedValue(pingTimeoutPerMinute, pingTimeoutPerMinute < maxPingTimeoutPerMinute);
        this.pingDuration = new CheckedValue(pingDuration, pingDuration < maxPingDuration);

        boolean hardCriteria = isActive && isConnected && readyToReceive;
        boolean sendingOk = this.sendingErrorRate.isOk
                && (this.sendingDuration.isOk || this.sendingRate < minSignificantRps);

        boolean softCriteria = sendingOk && this.pingTimeoutPerMinute.isOk;

        this.isHealthy = hardCriteria && softCriteria;
        this.canBeUsed = hardCriteria && (softCriteria || forceUse);
    }
}
