package ru.yandex.chemodan.queller.rabbit;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.misc.ip.Host;
import ru.yandex.misc.ip.IpPort;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author yashunsky
 */
public class RabbitConnectionPojo extends DefaultObject {
    public final Host host;
    public final IpPort port;
    public final String virtualHost;
    public final String username;
    public final String password;

    public final Duration declarationTimeout;
    public final Duration getPropertiesTimeout;

    public final Duration batchSendingTimeout;
    public final Duration batchConfirmationTimeout;
    public final Duration threadSleepInLoop;

    public final Duration listenerStartTimeout;
    public final Duration listenerStopTimeout;

    public final Duration channelCloseTimeout;

    public final int executorPoolSize;

    public RabbitConnectionPojo(Host host, IpPort port, String virtualHost, String username, String password,
            Duration declarationTimeout, Duration getPropertiesTimeout, Duration batchSendingTimeout,
            Duration batchConfirmationTimeout, Duration threadSleepInLoop, Duration listenerStartTimeout,
            Duration listenerStopTimeout, Duration channelCloseTimeout, int executorPoolSize)
    {
        this.host = host;
        this.port = port;
        this.virtualHost = virtualHost;
        this.username = username;
        this.password = password;
        this.declarationTimeout = declarationTimeout;
        this.getPropertiesTimeout = getPropertiesTimeout;
        this.batchSendingTimeout = batchSendingTimeout;
        this.batchConfirmationTimeout = batchConfirmationTimeout;
        this.threadSleepInLoop = threadSleepInLoop;
        this.listenerStartTimeout = listenerStartTimeout;
        this.listenerStopTimeout = listenerStopTimeout;
        this.channelCloseTimeout = channelCloseTimeout;
        this.executorPoolSize = executorPoolSize;
    }

    @Override
    public String toString() {
        return Tuple2List.fromPairs(
                "host", host,
                "port", port,
                "virtualHost", virtualHost,
                "username", username,
                "password", "***",
                "declarationTimeout", declarationTimeout,
                "getPropertiesTimeout", getPropertiesTimeout,
                "batchSendingTimeout", batchSendingTimeout,
                "batchConfirmationTimeout", batchConfirmationTimeout,
                "threadSleepInLoop", threadSleepInLoop,
                "listenerStartTimeout", listenerStartTimeout,
                "listenerStopTimeout", listenerStopTimeout,
                "channelCloseTimeout", channelCloseTimeout,
                "executorPoolSize", executorPoolSize).toMap().toString();
    }
}
