package ru.yandex.chemodan.queller.rabbit;

import java.lang.reflect.ParameterizedType;
import java.util.Map;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.ChannelManager;
import com.rabbitmq.client.impl.ChannelN;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionProxy;
import org.springframework.amqp.rabbit.connection.SimpleConnection;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.reflection.FieldX;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 * @author yashunsky
 */
public class RabbitHackUtils {

    public static final Function<CachingConnectionFactory, ListF<ChannelN>> getChannels =
            getF(CachingConnectionFactory.class, ConnectionProxy.class, "connection")
                    .andThen(ConnectionProxy::getTargetConnection)
                    .andThen(SimpleConnection.class::cast)

                    .andThen(getF(SimpleConnection.class, Connection.class, "delegate"))
                    .andThen(AMQConnection.class::cast)

                    .andThen(getF(AMQConnection.class, ChannelManager.class, "_channelManager"))
                    .andThen(getMapValuesF(ChannelManager.class, ChannelN.class, "_channelMap"));

    public static final Function<ChannelN, ListF<Consumer>> getConsumers =
            getMapValuesF(ChannelN.class, Consumer.class, "_consumers");

    public static boolean isLoaded() {
        return true;
    }

    @SuppressWarnings("unchecked")
    private static <C, F> Function<C, F> getF(FieldX field) {
        return (Function<C, F>) (Function) field::get;
    }

    private static <C, V> Function<C, ListF<V>> getMapValuesF(Class<C> clazz, Class<V> valueClazz, String fieldName) {
        FieldX field = ClassX.wrap(clazz).getDeclaredField(fieldName).setAccessibleTrueReturnThis();
        ParameterizedType type = field.getGenericType().asParameterizedType();

        Assert.equals(Map.class, type.getRawType());
        Assert.equals(valueClazz, type.getActualTypeArguments()[1]);

        return ((Function<Map<?, V>, ListF<V>>) map -> Cf.toList(map.values())).compose(getF(field));
    }

    private static <C, F> Function<C, F> getF(Class<C> clazz, Class<F> fieldClazz, String fieldName) {
        FieldX field = ClassX.wrap(clazz).getDeclaredField(fieldName).setAccessibleTrueReturnThis();
        Assert.isTrue(field.getType().isAssignableTo(fieldClazz));

        return getF(field);
    }
}
