package ru.yandex.chemodan.queller.rabbit;

import org.joda.time.Instant;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;

import ru.yandex.bolts.collection.Option;

/**
 * @author yashunsky
 */
public class RabbitPingMessage {
    private final Instant instant;

    public static Message create(){
        return new RabbitPingMessage().toMessage();
    }

    public Instant getInstant() {
        return instant;
    }

    public RabbitPingMessage() {
        this.instant = Instant.now();
    }

    public String toString() {
        return instant.toString();
    }

    public Message toMessage() {
        return new Message(toString().getBytes(), new MessageProperties());
    }

    public static Instant parse(String pingMessage) {
        return Instant.parse(pingMessage);
    }

    public static Instant parse(Message pingMessage) {
        return parse(new String(pingMessage.getBody()));
    }

    public static Option<Instant> parseSafe(String pingMessage) {
        try {
            return Option.of(parse(pingMessage));
        } catch (IllegalArgumentException e) {
            return Option.empty();
        }
    }

    public static Option<Instant> parseSafe(Message pingMessage) {
        return parseSafe(new String(pingMessage.getBody()));
    }
}
