package ru.yandex.chemodan.queller.rabbit;

import org.joda.time.Duration;
import org.springframework.amqp.core.Queue;

import ru.yandex.bolts.collection.Cf;

/**
 * @author dbrylev
 */
public class RabbitQueues {

    public static Queue durable(String name) {
        return new Queue(name, true, false, false);
    }

    public static Queue withExpiration(String name, Duration messageTtl, Duration xExpires) {
        return new Queue(name, true, false, false,
                Cf.map("x-message-ttl", messageTtl.getMillis(), "x-expires", xExpires.getMillis()));
    }
}
