package ru.yandex.chemodan.queller.rabbit;

import org.springframework.amqp.AmqpException;

import ru.yandex.bolts.collection.Option;

/**
 * @author dbrylev
 */
public class SendResult {

    public enum Status {
        SENT_CONFIRMED,
        SENT_NOT_CONFIRMED,
        ERROR,
        SKIPPED,
        NO_CONSUMERS,
    }

    public final Status status;
    public final Option<AmqpException> error;

    public SendResult(Status status, Option<AmqpException> error) {
        this.status = status;
        this.error = error;
    }

    public static SendResult status(Status status) {
        return new SendResult(status, Option.empty());
    }

    public static SendResult sentConfirmed() {
        return status(Status.SENT_CONFIRMED);
    }

    public static SendResult sentNotConfirmed() {
        return status(Status.SENT_NOT_CONFIRMED);
    }

    public static SendResult skipped() {
        return status(Status.SKIPPED);
    }

    public static SendResult noConsumers() {
        return status(Status.NO_CONSUMERS);
    }

    public static SendResult error(AmqpException error) {
        return new SendResult(Status.ERROR, Option.of(error));
    }

    public Option<AmqpException> getError() {
        return error;
    }

    public boolean isSentConfirmed() {
        return status == Status.SENT_CONFIRMED;
    }

    public boolean isSent() {
        return status == Status.SENT_CONFIRMED || status == Status.SENT_NOT_CONFIRMED;
    }
}
