package ru.yandex.chemodan.queller.support;

import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AbstractMessageConverter;
import org.springframework.amqp.support.converter.MessageConversionException;

import ru.yandex.chemodan.queller.celery.CeleryBender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.parse.BenderParser;
import ru.yandex.misc.bender.serialize.BenderSerializer;
import ru.yandex.misc.lang.CharsetUtils;

/**
 * @author dbrylev
 */
public class BenderJsonMessageConverter<T> extends AbstractMessageConverter {

    private final BenderParser<T> parser;
    private final BenderSerializer<Object> serializer;

    public BenderJsonMessageConverter(Class<T> clazz) {
        this(CeleryBender.mapper.createParserSerializer(clazz));
    }

    public BenderJsonMessageConverter(BenderParserSerializer<T> parserSerializer) {
        @SuppressWarnings("unchecked")
        BenderParserSerializer<Object> ps = (BenderParserSerializer<Object>) parserSerializer;

        this.parser = parserSerializer.getParser();
        this.serializer = ps.getSerializer();
    }

    @Override
    public T fromMessage(Message message) throws MessageConversionException {
        try {
            return parser.parseJson(message.getBody());
        } catch (Exception e) {
            throw new MessageConversionException("Failed to convert Message content", e);
        }
    }

    @Override
    protected Message createMessage(Object object, MessageProperties messageProperties) {
        byte[] bytes = serializer.serializeJson(object);

        messageProperties.setContentType(MessageProperties.CONTENT_TYPE_JSON);
        messageProperties.setContentEncoding(CharsetUtils.UTF8_CHARSET.name());
        messageProperties.setContentLength(bytes.length);

        return new Message(bytes, messageProperties);
    }
}
