package ru.yandex.chemodan.queller.utils;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.commune.alive2.location.LocationResolver;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author dbrylev
 */
public class ConductorUtils {

    private static final Logger logger = LoggerFactory.getLogger(ConductorUtils.class);

    public static ListF<String> resolveHostsFromString(LocationResolver locationResolver, String groupsOrHosts, Option<String> myDc) {
        logger.info("myDc: {}, groupsOrHosts: {}", myDc, groupsOrHosts);
        ListF<String> hosts = locationResolver.resolveHostsFromString(groupsOrHosts);
        logger.info("resolved hosts (all): {}", hosts);

        if (myDc.isPresent()) {
            Function<String, String> getDc = host -> locationResolver.resolveLocationFor(Option.of(host)).dcName
                    .getOrThrow("Dc is unknown to Conductor for host ", host);

            hosts = hosts.filter(getDc.andThenEquals(myDc.get()));
            logger.info("myDc hosts (filtered): {}", hosts);
        }
        return hosts;
    }
}
