package ru.yandex.chemodan.queller.worker;

import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.bazinga.BazingaWorkerConfigurationContextConfiguration;
import ru.yandex.commune.bazinga.BazingaConfiguration;
import ru.yandex.commune.bazinga.BazingaWorkerApp;
import ru.yandex.commune.bazinga.impl.TaskOverridesManager;
import ru.yandex.commune.bazinga.impl.storage.BazingaStorage;
import ru.yandex.commune.bazinga.impl.worker.BazingaWorkerConfiguration;
import ru.yandex.commune.bazinga.impl.worker.LogDirManager;
import ru.yandex.commune.bazinga.impl.worker.WorkerTaskRegistry;
import ru.yandex.commune.bazinga.impl.worker.WorkerTaskRunner;
import ru.yandex.commune.zk2.client.ZkManager;
import ru.yandex.commune.zk2.client.ZkManagerContextConfiguration;
import ru.yandex.commune.zk2.primitives.observer.ZkPathObserver;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        BazingaWorkerConfigurationContextConfiguration.class,
        ZkManagerContextConfiguration.class,
})
public class BazingaBeansContextConfiguration {

    @Autowired
    private Optional<BazingaWorkerApp> bazingaWorkerApp;

    @Bean
    public WorkerTaskRunner workerTaskRunner(LogDirManager logDirManager, BazingaWorkerConfiguration workerConf) {
        return new WorkerTaskRunner((BazingaStorage) null, logDirManager, workerConf.getForkedTaskClass());
    }

    @Bean
    public WorkerTaskRegistry workerTaskRegistry() {
        return bazingaWorkerApp.isPresent()
                ? bazingaWorkerApp.get().getWorkerTaskRegistry()
                : new WorkerTaskRegistry();
    }

    @Bean
    public TaskOverridesManager taskOverridesManager(BazingaConfiguration bazingaConfiguration,
            ZkManager zkManager, ZkPathObserver zkPathObserver)
    {
        return bazingaWorkerApp.isPresent()
                ? bazingaWorkerApp.get().getTaskOverridesManager()
                : new TaskOverridesManager(bazingaConfiguration, zkManager, zkPathObserver);
    }

    @Bean
    public LogDirManager logDirManager(WorkerTaskRegistry taskRegistry, BazingaWorkerConfiguration workerConf) {
       return bazingaWorkerApp.isPresent()
               ? bazingaWorkerApp.get().getLogDirManager()
               : new LogDirManager(workerConf.getLogConfiguration(), taskRegistry);
    }
}
