package ru.yandex.chemodan.queller.worker;

import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.commune.bazinga.context.BazingaWorkerTaskInitializer;
import ru.yandex.commune.bazinga.impl.TaskOverridesManager;
import ru.yandex.commune.bazinga.impl.worker.LogDirManager;
import ru.yandex.commune.bazinga.impl.worker.WorkerTaskRegistry;
import ru.yandex.misc.spring.Service;
import ru.yandex.misc.spring.ServiceSupport;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        BazingaBeansContextConfiguration.class,
})
public class BazingaStubContextConfiguration {

    @Bean
    public Service bazingaWorkerApp(TaskOverridesManager taskOverridesManager, LogDirManager logDirManager) {
        return new ServiceSupport() {
            protected void doStart() {
                taskOverridesManager.start();
                logDirManager.start();
            }
        };
    }

    @Bean
    public BazingaWorkerTaskInitializer bazingaWorkerTaskInitializer(
            ApplicationContext context, WorkerTaskRegistry registry)
    {
        return new BazingaWorkerTaskInitializer(context, registry);
    }
}
