package ru.yandex.chemodan.queller.worker;

import org.joda.time.Duration;

import ru.yandex.misc.monica.annotation.GroupByDefault;
import ru.yandex.misc.monica.annotation.MonicaContainer;
import ru.yandex.misc.monica.annotation.MonicaMetric;
import ru.yandex.misc.monica.core.blocks.Counter;
import ru.yandex.misc.monica.core.blocks.InstrumentMap;
import ru.yandex.misc.monica.core.blocks.MeterMap;
import ru.yandex.misc.monica.core.blocks.MetricWithHealth;
import ru.yandex.misc.monica.core.blocks.MetricWithHealthUtils;
import ru.yandex.misc.monica.core.blocks.RoundRobinCounterMap;
import ru.yandex.misc.monica.core.name.MetricGroupName;
import ru.yandex.misc.monica.core.name.MetricName;

/**
 * @author dbrylev
 */
public class CeleryJavaWorkerMetrics implements MonicaContainer {

    @MonicaMetric(description = "Tasks invocations")
    @GroupByDefault
    public final InstrumentMap tasksInvocations = new InstrumentMap();

    @MonicaMetric(description = "Tasks invocations count")
    @GroupByDefault
    public final RoundRobinCounterMap tasksInvocationsCount = new RoundRobinCounterMap(Duration.standardMinutes(5));

    @MonicaMetric(description = "Tasks preparation errors")
    @GroupByDefault
    public final MeterMap tasksPreparationErrors = new MeterMap();

    public final Counter tasksPreparationErrorsCounter = new Counter();

    @MonicaMetric(description = "Tasks preparation errors (total)")
    @GroupByDefault
    public final MetricWithHealth<Long> tasksPreparationErrorsTotal =
            new MetricWithHealth<>(tasksPreparationErrorsCounter, MetricWithHealthUtils.inThresholdsF(0, 1));

    public final Counter resubmitToRabbitErrorsCounter = new Counter();

    @MonicaMetric(description = "Errors during send failed tasks back to rabbit (total)")
    @GroupByDefault
    public final MetricWithHealth<Long> resubmitToRabbitErrorsTotal =
            new MetricWithHealth<>(resubmitToRabbitErrorsCounter, MetricWithHealthUtils.inThresholdsF(0, 1));

    @Override
    public MetricGroupName groupName(String instanceName) {
        return new MetricGroupName("celery", new MetricName("celery", "javaWorker"), "Celery java tasks execution");
    }
}
