package ru.yandex.chemodan.queller.worker;

import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskCategory;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;

/**
 * @author dbrylev
 */
public abstract class CeleryOnetimeTask extends OnetimeTaskSupport<CeleryOnetimeTaskParameters> {

    public static final TaskCategory BAZINGA_CATEGORY = new TaskCategory("celery");
    public static final TaskQueueName BAZINGA_QUEUE_NAME = new TaskQueueName("celery");

    public CeleryOnetimeTask(CeleryOnetimeTaskParameters parameters) {
        super(parameters);
    }

    public CeleryOnetimeTask() {
        super(CeleryOnetimeTaskParameters.class);
    }

    /**
     * MUST be different from {@link OnetimeTask#id()}
     *
     * @return celery task id.
     */
    protected abstract TaskId celeryTaskId();

    @Override
    public final TaskId id() {
        return celeryTaskId();
    }

    @Override
    public TaskQueueName queueName() {
        return BAZINGA_QUEUE_NAME;
    }

    @Override
    public TaskCategory getTaskCategory() {
        return BAZINGA_CATEGORY;
    }

    @Override
    public int priority() {
        return 0;
    }
}
