package ru.yandex.chemodan.queller.worker;

import lombok.Builder;
import lombok.Value;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;

/**
 * @author eoshch
 */
@Value
@Builder(toBuilder = true)
public class CeleryOnetimeTaskContext {
    @Builder.Default
    private final Option<Integer> currentTry = Option.empty();

    @Builder.Default
    private final Option<Integer> maxRetries = Option.empty();

    @Builder.Default
    private final Option<Instant> created = Option.empty();

    @Builder.Default
    private final Option<String> activeUid = Option.empty();
}
