package ru.yandex.chemodan.queller.worker;

import javax.annotation.Nullable;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.json.JsonValue;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderIgnore;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author dbrylev
 */
@BenderBindAllFields
public class CeleryOnetimeTaskParameters extends DefaultObject {
    public final ListF<JsonValue> args;
    public final MapF<String, JsonValue> kwargs;
    public final Option<String> ycrid;

    @BenderIgnore
    @Nullable
    private final CeleryOnetimeTaskContext context;

    public CeleryOnetimeTaskParameters(ListF<JsonValue> args, MapF<String, JsonValue> kwargs) {
        this(args, kwargs, Option.empty(), null);
    }

    public CeleryOnetimeTaskParameters(ListF<JsonValue> args, MapF<String, JsonValue> kwargs, Option<String> ycrid) {
        this(args, kwargs, ycrid, null);
    }

    public CeleryOnetimeTaskParameters(
            ListF<JsonValue> args, MapF<String, JsonValue> kwargs,
            Option<String> ycrid, @Nullable CeleryOnetimeTaskContext context)
    {
        this.args = args;
        this.kwargs = kwargs;
        this.ycrid = ycrid;
        this.context = context;
    }

    public CeleryOnetimeTaskParameters withYcrid(String ycrid) {
        return new CeleryOnetimeTaskParameters(args, kwargs, Option.of(ycrid), context);
    }

    public CeleryOnetimeTaskParameters withYcrid(Option<String> ycrid) {
        return new CeleryOnetimeTaskParameters(args, kwargs, ycrid, context);
    }

    public CeleryOnetimeTaskParameters withContext(CeleryOnetimeTaskContext context) {
        return new CeleryOnetimeTaskParameters(args, kwargs, ycrid, context);
    }

    public Option<CeleryOnetimeTaskContext> getContext() {
        return Option.ofNullable(context);
    }
}
