package ru.yandex.chemodan.queller.worker;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.commune.bazinga.BazingaBender;
import ru.yandex.commune.json.JsonArray;
import ru.yandex.commune.json.JsonNumber;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.commune.json.JsonString;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
public class CeleryOnetimeTaskParametersTest {

    @Test
    public void parse() {
        JsonNumber number = JsonNumber.valueOf(1);
        JsonString string = JsonString.valueOf("1");
        JsonObject object = new JsonObject(Cf.map("str", string));
        JsonArray array = new JsonArray(Cf.list(number, string, object));

        CeleryOnetimeTaskParameters params = new CeleryOnetimeTaskParameters(
                Cf.list(number, string, object, array),
                Cf.toMap(Tuple2List.fromPairs("num", number, "str", string, "arr", array, "obj", object)));

        byte[] serialized = BazingaBender.mapper.serializeJson(params);

        Assert.equals(params, BazingaBender.mapper.parseJson(CeleryOnetimeTaskParameters.class, serialized));
    }
}
