package ru.yandex.chemodan.queller.worker;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.queller.rabbit.RabbitPool;
import ru.yandex.chemodan.queller.rabbit.RabbitPoolContextConfiguration;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        RabbitPoolContextConfiguration.class,
})
public class CeleryTaskManagerContextConfiguration {

    @Bean
    public CeleryTaskManager celeryTaskManager(RabbitPool rabbitPool) {
        return new CeleryTaskManager(rabbitPool);
    }
}
