package ru.yandex.chemodan;

import org.apache.commons.lang3.StringUtils;
import org.joda.time.Duration;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

import ru.yandex.bolts.collection.Option;

/**
 * @author Maksim Ahramovich
 */
public class ConfigurableTaskUtils {
    private static final PeriodFormatter TIMEOUT_FORMATTER = new PeriodFormatterBuilder()
            .appendDays().appendSuffix("d").appendSeparator(" ")
            .appendHours().appendSuffix("h").appendSeparator(" ")
            .appendMinutes().appendSuffix("m").appendSeparator(" ")
            .appendSeconds().appendSuffix("s")
            .toFormatter();

    public static Option<Duration> parseTimeout(String timeout) {
        return StringUtils.isBlank(timeout) ?
                Option.empty() :
                Option.of(TIMEOUT_FORMATTER.parsePeriod(timeout).toStandardDuration());
    }
}
