package ru.yandex.chemodan;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function0V;
import ru.yandex.chemodan.util.ExecUtils2;
import ru.yandex.commune.bazinga.BazingaStopExecuteException;
import ru.yandex.misc.io.exec.ExecResult;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author vavinov
 */
public class MpfsShellUtils {
    private static final Logger logger = LoggerFactory.getLogger(MpfsShellUtils.class);

    // CHEMODAN-12115
    public static final int EXIT_CODE_OK = 0;
    public static final int EXIT_CODE_RETRY_LATER = 50;

    public static Function0V executeF(final ListF<String> command) {
        return () -> execute(command);
    }

    public static ExecResult execute(ListF<String> command) {
        return execute(command, true);
    }

    public static ExecResult execute(ListF<String> command, boolean stopExecutionOnBadCode) {
        ExecResult r = ExecUtils2.executeGrabbingOutputWithLogging(command);

        if (r.getCode() != EXIT_CODE_OK) {
            String message = "Execution of command=" + command + " failed, code=" + r.getCode();
            logger.info("Script output: {}", r.getOutputJoined());
            if (r.getCode() == EXIT_CODE_RETRY_LATER) {
                throw new RuntimeException(message);
            } else {
                throw new BazingaStopExecuteException(message);
            }
        }
        return r;
    }
}
