package ru.yandex.chemodan;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.commune.bazinga.BazingaBender;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.OnetimeTask;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.reflection.ClassX;
import ru.yandex.misc.reflection.TypeX;

/**
 * @author tolmalev
 */
public class OnetimeTaskUtils {
    private static final SetF<String> taskGroups = Cf.set("tasks", "python");

    private static final String TASK_CLASS_PREFIX = "ru.yandex.chemodan.core.worker.";

    public static OnetimeTask makeOnetimeTask(TaskId taskId, String jsonParametersString) {
        // XXX porn

        Class<?> taskClazz = getTaskClass(StringUtils.capitalize(taskId.getId()));
        ClassX<? extends OnetimeTaskSupport> taskClass = ClassX.wrap(taskClazz).uncheckedCast();

        return taskClass.newInstance(
                BazingaBender.mapper.createParser(getParametersClass(taskClass.getClazz()))
                        .parseJson(jsonParametersString));
    }

    public static Class<?> getParametersClass(Class<? extends OnetimeTaskSupport> taskClass) {
        TypeX support = TypeX.wrap(taskClass);

        while (!support.erasure().is(OnetimeTaskSupport.class)) {
            support = support.erasure().getGenericSuperclass().getOrThrow("Not OnetimeTaskSupport ", taskClass);
        }
        return support.getActualTypeArguments().single().erasure().getClazz();
    }

    private static Class<?> getTaskClass(String shortTaskClassName) {
        for (String group : taskGroups) {
            try {
                String fullClassName = TASK_CLASS_PREFIX + group + "." + shortTaskClassName;
                return Class.forName(fullClassName);

            } catch (ClassNotFoundException e) {
            }
        }
        throw new RuntimeException(new ClassNotFoundException(shortTaskClassName));
    }
}
