package ru.yandex.chemodan;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;
import ru.yandex.misc.io.exec.ExecResult;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author tolmalev
 */
public class RecountCronTask extends CronTask {
    private static final Logger logger = LoggerFactory.getLogger(RecountCronTask.class);

    private final Duration period;
    private final Duration timeout;

    public RecountCronTask(Duration period, Duration timeout) {
        this.timeout = timeout;
        this.period = period;
    }

    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(period);
    }

    @Override
    public Duration timeout() {
        return timeout;
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        ExecResult execute = MpfsShellUtils.execute(Cf.list("/usr/sbin/mpfs-admin-recount.py"));
    }
}
