package ru.yandex.chemodan.blackbox;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.exception.AccessForbiddenException;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxCorrectResponse;
import ru.yandex.misc.ip.IpAddress;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author friendlyevil
 */
@AllArgsConstructor
public class BlackboxAuthHelper {
    private static final String SESSION_ID_COOKIE_NAME = "Session_id";
    private final Blackbox2 blackbox2;
    private final String domain;

    public BlackboxCorrectResponse authBySessionId(HttpServletRequestX request) throws Exception {
        Option<IpAddress> xRealIp = request.getXRealIp();
        Option<String> sessionId = request.getCookieValueO(SESSION_ID_COOKIE_NAME);

        if (xRealIp.isEmpty() || sessionId.isEmpty()) {
            throw new AccessForbiddenException("Request doesn't contains ip or cookies");
        }

        return blackbox2.query().sessionId(xRealIp.get(), sessionId.get(), domain);
    }
}
