package ru.yandex.chemodan.blackbox;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.log.DiskLog4jRequestLog;
import ru.yandex.chemodan.util.exception.AccessForbiddenException;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.commune.a3.utils.Ordered;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.inside.passport.blackbox2.protocol.response.BlackboxCorrectResponse;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author friendlyevil
 */
@AllArgsConstructor
public class BlackboxAuthInterceptor implements ActionInvocationInterceptor {
    private final BlackboxAuthHelper ytBlackboxHelper;

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        HttpServletRequestX request = invocation.getWebRequest().getHttpServletRequest();
        BlackboxCorrectResponse response = ytBlackboxHelper.authBySessionId(request);
        Option<PassportUid> uid = response.getUid();
        Option<String> login = response.getLogin();
        if (uid.isEmpty() || login.isEmpty()) {
            throw new AccessForbiddenException("Uid or login not found in blackbox answer");
        }

        request.setAttribute(DiskLog4jRequestLog.UID_ATTRIBUTE, uid.get());
        request.setAttribute(DiskLog4jRequestLog.LOGIN_ATTRIBUTE, login.get());

        return invocation.invoke();
    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE;
    }
}
