package ru.yandex.chemodan.blackbox;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

/**
 * @author tolmalev
 */
@Configuration
public class ProdBlackboxContextConfiguration {
    @Bean
    public Blackbox2 blackbox2(@Value("${blackbox.url}") String blackboxHost) {
        return Blackbox2.cons(blackboxHost, blackboxHttpClientConfigurator().configure());
    }

    @Bean
    @OverridableValuePrefix("blackbox")
    public HttpClientConfigurator blackboxHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }
}
