package ru.yandex.chemodan.blackbox;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

/**
 * @author tolmalev
 */
@Configuration
public class YtBlackboxContextConfiguration {
    @Bean
    public Blackbox2 ytBlackbox2(@Value("${yt.blackbox.url}") String ytBlackboxUrl) {
        return Blackbox2.cons(ytBlackboxUrl, blackboxHttpClientConfigurator().configure());
    }
    @Bean
    public BlackboxAuthHelper ytBlackboxHelper(@Qualifier("ytBlackbox2") Blackbox2 ytBlackbox2,
                                               @Value("${yt.blackbox.cookie.domain}") String domain) {
        return new BlackboxAuthHelper(ytBlackbox2, domain);
    }

    @Bean
    @OverridableValuePrefix("yt_blackbox")
    public HttpClientConfigurator blackboxHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }
}
