package ru.yandex.chemodan.boot;

import lombok.Data;
import org.springframework.context.ApplicationContext;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.http.KeepUaasHeadersInterceptor;
import ru.yandex.chemodan.util.web.BenderJsonParameterBinder;
import ru.yandex.chemodan.util.web.MasterSlaveUnavailableExceptionHandler;
import ru.yandex.chemodan.util.web.SuppressInvocationInfoJsonPojoResultSerializer;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.ActionConfigurationBuilder;
import ru.yandex.commune.a3.ActionConfigurator;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.CloneableAction;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.parameter.convert.ConverterToType;
import ru.yandex.commune.a3.action.parameter.convert.DefaultConverters;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.ResultSerializer;
import ru.yandex.commune.a3.action.result.SimpleResultSerializer;
import ru.yandex.commune.a3.action.result.error.A3ExceptionHandler;
import ru.yandex.commune.a3.action.result.error.AnyExceptionHandler;
import ru.yandex.commune.a3.action.result.error.ExceptionHandler;
import ru.yandex.commune.a3.action.result.error.HttpStatusCodeSourceExceptionHandler;
import ru.yandex.commune.a3.action.result.error.nested.ExceptionWithRootElementHandler;
import ru.yandex.commune.a3.action.result.json.JsonResultSerializer;
import ru.yandex.commune.a3.action.result.pojo.JsonPojoResultSerializer;
import ru.yandex.commune.a3.action.result.type.AcceptHeaderHandler;
import ru.yandex.commune.a3.action.result.type.JsonPathInfoHandler;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.commune.a3.action.result.type.ResultTypeHandler;
import ru.yandex.commune.a3.action.result.type.ResultTypeParameterHandler;
import ru.yandex.commune.a3.db.MasterSlavePolicyInterceptor;
import ru.yandex.commune.a3.security.SecurityExceptionHandler;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.spring.ApplicationContextUtils;

/**
 * @author dbrylev
 */
@Data
public class ChemodanActionAppConfigurator {

    private static final ListF<ConverterToType> defaultConverters =
            DefaultConverters.all().getConverters();

    private static final ListF<ResultTypeHandler> defaultResultTypeHandlers = Cf.list(
            new JsonPathInfoHandler(),
            new ResultTypeParameterHandler(),
            new AcceptHeaderHandler());

    private static final ListF<ExceptionHandler> defaultExceptionHandlers = Cf.list(
            new ExceptionWithRootElementHandler(),
            new A3ExceptionHandler(),
            new HttpStatusCodeSourceExceptionHandler(),
            new SecurityExceptionHandler(),
            new MasterSlaveUnavailableExceptionHandler(),
            new AnyExceptionHandler());

    private static final ListF<ResultSerializer> defaultResultSerializers = Cf.list(
            new SimpleResultSerializer(),
            new JsonResultSerializer());

    private static final ListF<ActionInvocationInterceptor> defaultInvocationInterceptors = Cf.list(
            new MasterSlavePolicyInterceptor(),
            new KeepUaasHeadersInterceptor()
    );

    private static final MediaType defaultResultType = MediaType.APPLICATION_JSON;


    private final ActionConfigurationBuilder builder;
    private final ListF<Object> actions;

    public static ChemodanActionAppConfigurator cons(ApplicationInfo application, ApplicationContext context) {
        ActionConfigurationBuilder builder = ActionConfigurationBuilder.cons(application)
                .setConverters(defaultConverters)
                .setResultTypeHandlers(defaultResultTypeHandlers)
                .setExceptionHandlers(defaultExceptionHandlers)
                .setResultSerializers(defaultResultSerializers)
                .setInvocationInterceptors(defaultInvocationInterceptors)
                .setResultType(defaultResultType);

        ListF<CloneableAction> cloneableActions = ApplicationContextUtils
                .beansOfType(context, CloneableAction.class);

        ListF<Object> actionContainers = ApplicationContextUtils
                .beansWithAnnotationList(context, ActionContainer.class)
                .get2();

        return new ChemodanActionAppConfigurator(builder, actionContainers.plus(cloneableActions));
    }

    public ChemodanActionAppConfigurator addJsonBendingWithoutInvocationInfo(BenderMapper mapper) {
        getBuilder()
                .addResultSerializers(Cf.list(
                        new SuppressInvocationInfoJsonPojoResultSerializer(mapper)))

                .addParameterBinders(Cf.list(
                        new BenderJsonParameterBinder(mapper)));

        return this;
    }

    public ChemodanActionAppConfigurator addJsonBending(BenderMapper mapper) {
        getBuilder()
                .addResultSerializers(Cf.list(
                        new JsonPojoResultSerializer(mapper)))

                .addParameterBinders(Cf.list(
                        new BenderJsonParameterBinder(mapper)));

        return this;
    }

    public ActionApp configure() {
        return ActionConfigurator.configure(actions, builder);
    }
}
