package ru.yandex.chemodan.boot;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.dc.closing.ClosedDataCenterContextConfiguration;
import ru.yandex.chemodan.monica.BucketsFromStatisticsDataExtractor;
import ru.yandex.chemodan.monica.DiskGraphiteMetricsRegistry;
import ru.yandex.chemodan.sql.SqlBetaAdminContextConfiguration;
import ru.yandex.chemodan.util.ping.PingerChecker;
import ru.yandex.chemodan.util.servicemap.ServiceMapContextConfiguration;
import ru.yandex.chemodan.zk.ChemodanZkPathsContextConfiguration;
import ru.yandex.chemodan.zk.registries.tvm.ZkTvm2MpfsContextConfiguration;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.alive2.admin.AliveAppsAdminContextConfiguration;
import ru.yandex.commune.alive2.location.LocationResolverConfiguration;
import ru.yandex.commune.dynproperties.DynamicPropertiesContextConfiguration;
import ru.yandex.commune.dynproperties.DynamicPropertyBenderMapperHolder;
import ru.yandex.commune.dynproperties.admin.DynamicPropertiesAdminContextConfiguration;
import ru.yandex.commune.zk2.ZkConfiguration;
import ru.yandex.commune.zk2.ZkMediaDevelopmentUtils;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;
import ru.yandex.commune.zk2.client.ZkManagerContextConfiguration;
import ru.yandex.inside.admin.conductor.Conductor;
import ru.yandex.inside.admin.conductor.ConductorContextConfiguration;
import ru.yandex.inside.admin.conductor.GroupOrHost;
import ru.yandex.inside.passport.tvm2.web.Tvm2ServletFilterContextConfiguration;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.Version;

/**
 * @author vavinov
 */
@Configuration
@Import({
        ZkManagerContextConfiguration.class,
        LocationResolverConfiguration.class,
        ConductorContextConfiguration.class,
        ChemodanMonicaConfigurtion.class,
        AliveAppsAdminContextConfiguration.class,
        DynamicPropertiesContextConfiguration.class,
        DynamicPropertiesAdminContextConfiguration.class,
        Tvm2ServletFilterContextConfiguration.class,
        ZkTvm2MpfsContextConfiguration.class,
        ClosedDataCenterContextConfiguration.class,
        ChemodanZkPathsContextConfiguration.class,
        ServiceMapContextConfiguration.class,
        SqlBetaAdminContextConfiguration.class
})
public class ChemodanCommonContextConfiguration {

    @Bean
    public PingerChecker slashMaintenanceFileChecker() {
        return new MaintenanceLockPingerChecker();
    }

    @Bean
    public ZkConfiguration zkConfiguration(
            @Value("${zk.hosts}") String hosts,
            Conductor conductor,
            EnvironmentType environmentType)
    {
        if (StringUtils.isNotBlank(hosts)) {
            return new ZkConfiguration(conductor.hostsFromString(GroupOrHost.valueOf(hosts)));
        }

        Check.isTrue(Cf.set(EnvironmentType.DEVELOPMENT, EnvironmentType.TESTS).containsTs(environmentType));
        return new ZkConfiguration(ZkMediaDevelopmentUtils.hostsNoEnvCheck());
    }

    @Bean
    public DiskGraphiteMetricsRegistry diskGraphiteMetricsRegistry(
            ZkManager zkManager,
            @Qualifier("zkRoot")
                    ZkPath zkRoot,
            @Value("${graphite.pusher.registry.zk.path:-graphite/pusher/registry}")
                    String childPath)
    {
        DiskGraphiteMetricsRegistry registry = new DiskGraphiteMetricsRegistry(zkRoot.child(childPath));
        zkManager.addClient(registry);
        return registry;
    }

    @Bean
    public BucketsFromStatisticsDataExtractor bucketFromStatisticsDataExtractor() {
        return new BucketsFromStatisticsDataExtractor();
    }

    @Bean
    public Version version() {
        return DiskAppVersion.VERSION;
    }

    @Bean
    public ApplicationInfo applicationInfo(
            AppName appName,
            DiskAppVersion appVersion)
    {
        return new ApplicationInfo(appName.appName(), appVersion.getProjectVersion());
    }

    @Bean
    public DynamicPropertyBenderMapperHolder dynamicPropertyBenderMapperHolder() {
        return new DynamicPropertyBenderMapperHolder(new BenderMapper());
    }
}
