package ru.yandex.chemodan.boot;

import java.beans.PropertyEditor;

import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.boot.value.OverridableValuePostProcessor;
import ru.yandex.inside.admin.conductor.GroupOrHost;
import ru.yandex.inside.admin.conductor.GroupOrHostPropertyEditor;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.dataSize.DataSizePropertyEditor;
import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.io.file.File2Editor;
import ru.yandex.misc.ip.HostPort;
import ru.yandex.misc.ip.HostPortEditor;
import ru.yandex.misc.ip.IpPort;
import ru.yandex.misc.ip.IpPortPropertyEditor;
import ru.yandex.misc.parse.CommaSeparated;
import ru.yandex.misc.property.PropertiesHolder;
import ru.yandex.misc.property.eval.PropertyPlaceholderConfigurer2;
import ru.yandex.misc.spring.ServicesStarter;
import ru.yandex.misc.spring.initializer.InitMethodInvokerConfiguration;
import ru.yandex.misc.time.DateTimePropertyEditor;
import ru.yandex.misc.time.DurationPropertyEditor;
import ru.yandex.misc.time.LocalDatePropertyEditor;

/**
 * @author vavinov
 */
@Configuration
@Import({InitMethodInvokerConfiguration.class})
public class ChemodanInitContextConfiguration {

    public static MapF<Class<?>, Class<? extends PropertyEditor>> getChemodanCustomEditors() {
        return Cf.<Class<?>, Class<? extends PropertyEditor>>map()
                .plus1(File2.class, File2Editor.class)
                .plus1(Duration.class, DurationPropertyEditor.class)
                .plus1(DataSize.class, DataSizePropertyEditor.class)
                .plus1(HostPort.class, HostPortEditor.class)
                .plus1(CommaSeparated.class, CommaSeparated.Editor.class)
                .plus1(LocalDate.class, LocalDatePropertyEditor.class)
                .plus1(DateTime.class, DateTimePropertyEditor.class)
                .plus1(IpPort.class, IpPortPropertyEditor.class)
                .plus1(GroupOrHost.class, GroupOrHostPropertyEditor.class);
    }

    @Bean
    public static PropertyPlaceholderConfigurer2 propertyPlaceholderConfigurer2() {
        final PropertyPlaceholderConfigurer2 configurer2 = new PropertyPlaceholderConfigurer2();
        configurer2.setProperties(PropertiesHolder.properties());
        return configurer2;
    }

    @Bean
    public ServicesStarter servicesStarter() {
        return new ServicesStarter();
    }

    @Bean
    public static CustomEditorConfigurer customEditorConfigurer() {
        final CustomEditorConfigurer configurer = new CustomEditorConfigurer();
        configurer.setCustomEditors(getChemodanCustomEditors());
        return configurer;
    }

    @Bean
    public static OverridableValuePostProcessor valueOverrideBeanPostProcessor() {
        return new OverridableValuePostProcessor();
    }
}
