package ru.yandex.chemodan.boot;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.commune.alive2.location.TestLocationResolverConfiguration;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.property.PropertiesHolder;
import ru.yandex.misc.property.eval.PropertyPlaceholderConfigurer2;
import ru.yandex.misc.property.load.PropertiesLoader;
import ru.yandex.misc.version.AppName;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
@Import({
        ChemodanInitContextConfiguration.class,
        TestLocationResolverConfiguration.class,
})
public abstract class ChemodanTestBaseContextConfiguration {
    @Bean
    protected abstract AppName appName();

    @Bean
    public EnvironmentType environmentType() {
        return EnvironmentType.TESTS;
    }

    @Bean
    public PropertyPlaceholderConfigurer2 propertyPlaceholderConfigurer2() {
        PropertyPlaceholderConfigurer2 configurer2 = new PropertyPlaceholderConfigurer2();
        PropertiesLoader.initialize(new ChemodanPropertiesLoadStrategy(appName(), true));
        configurer2.setProperties(PropertiesHolder.properties());
        return configurer2;
    }
}
