package ru.yandex.chemodan.boot;

import java.util.List;
import java.util.Optional;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.util.ping.CoolPingServlet;
import ru.yandex.chemodan.util.ping.PingerChecker;

/**
 * @author tolmalev
 */
@Configuration
public class CoolPingServletContextConfiguration {
    @Bean
    public CoolPingServlet coolPingServlet(Optional<List<PingerChecker>> checkers) {
        return new CoolPingServlet(checkers.map(Cf::x).orElse(Cf.list()));
    }
}
