package ru.yandex.chemodan.boot;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Value;

import ru.yandex.misc.io.file.File2;
import ru.yandex.misc.jvm.ThreadMonitorUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.time.TimeUtils;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * @author vavinov
 */
public class DumpThreadsService extends DelayingWorkerServiceBeanSupport {
    private static final Logger logger = LoggerFactory.getLogger(DumpThreadsService.class);

    @Value("${dump.threads.dir}")
    private File2 dir;

    @Value("${dump.threads.enabled}")
    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    @Value("${dump.threads.delay}")
    @Override
    public void setDelay(Duration delay) {
        super.setDelay(delay);
    }

    @Override
    protected void execute() throws Exception {
        File2 file = dir.child(TimeUtils.SUITABLE_FOR_FILENAME_DATE_TIME_FORMATTER.print(new Instant()));
        file.write(ThreadMonitorUtils.dumpFullInfo());
    }
}
