package ru.yandex.chemodan.boot.admin;

import org.joda.time.Duration;

import ru.yandex.commune.db.admin.dbs.DbsAdminPage;
import ru.yandex.misc.db.masterSlave.DataSourceWithStatus;
import ru.yandex.misc.monica.annotation.MonicaContainer;
import ru.yandex.misc.monica.annotation.MonicaMetric;
import ru.yandex.misc.monica.core.blocks.ValueMap;
import ru.yandex.misc.monica.core.name.MetricGroupName;
import ru.yandex.misc.monica.core.name.MetricName;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * @author tolmalev
 */
public class DbsMetrics extends DelayingWorkerServiceBeanSupport implements MonicaContainer {
    private final DbsAdminPage dbsAdminPage;

    @MonicaMetric
    private final ValueMap<Integer> metricsByUrl = new ValueMap<>(Integer.class, 1000);

    public DbsMetrics(DbsAdminPage dbsAdminPage) {
        this.dbsAdminPage = dbsAdminPage;
    }

    @Override
    protected Duration defaultDelay() {
        return Duration.standardSeconds(1);
    }

    @Override
    protected void execute() throws Exception {
        DbsAdminPage.Result status = dbsAdminPage.index();

        for (DbsAdminPage.ShardInfoPojo shard : status.shards) {
            shard.dataSources.forEach(this::updateDsMetrics);
        }

        status.shards.forEach(shard -> shard.dataSources.forEach(this::updateDsMetrics));
        status.networkAwareDataSources.forEach(na -> na.info.forEach(this::updateDsMetrics));
    }

    private void updateDsMetrics(DataSourceWithStatus ds) {
        String url = ds.getShortUrlOrSomething();

        metricsByUrl.set(ds.isMaster().orElseGet(() -> false) ? 1 : 0, url, "is_master");
        metricsByUrl.set(ds.isAvailable().orElseGet(() -> false) ? 1 : 0, url, "is_available");
        metricsByUrl.set(ds.getOpenConnectionCount().orElseGet(() -> 0), url, "open_connections");
        metricsByUrl.set(ds.getIdleConnectionCount().orElseGet(() -> 0), url, "idle_connections");
    }

    @Override
    public MetricGroupName groupName(String instanceName) {
        return new MetricGroupName(
                "dbs-connections-metrics",
                new MetricName("dbs", "connections"),
                "Metrics of db connections"
        );
    }
}
