package ru.yandex.chemodan.boot.admin;

import java.io.IOException;
import java.util.Enumeration;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import ru.yandex.misc.io.InputStreamXUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * For debug purposes.
 *
 * @author vavinov
 */
public class LogRequestServlet extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(LogRequestServlet.class);

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.info(req.getMethod() + " " + req.getRequestURL() + req.getQueryString() + req.getProtocol());
        for (Enumeration<String> h = req.getHeaderNames(); h.hasMoreElements();) {
            String name = h.nextElement();
            for (Enumeration<String> v = req.getHeaders(name); v.hasMoreElements();) {
                logger.info(name + ": " + v.nextElement());
            }
        }
        logger.info(InputStreamXUtils.wrap(req.getInputStream()).readString());
    }
}
