package ru.yandex.chemodan.boot.admin.idm;

import java.util.Set;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.ToString;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author swined
 */
@BenderBindAllFields
@ToString
@AllArgsConstructor
public class AppAccess {

    @Getter private final String app;
    @Getter private final Set<String> defaultRoles;
    @Getter private final MapF<String, Set<String>> roleMap;

    public static AppAccess empty(String app) {
        return new AppAccess(app, Cf.hashSet(), Cf.hashMap());
    }

}
