package ru.yandex.chemodan.boot.admin.idm;

import java.util.function.Consumer;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.version.AppName;

/**
 * @author swined
 */
public class AppsRegistry extends ZkRegistry<String, AppAccess> {

    public AppsRegistry(ZkPath path) {
        super(
                path,
                new BenderMapper().createParserSerializer(AppAccess.class),
                AppAccess::getApp,
                Function.identityF()
        );
    }

    public Option<AppAccess> get(AppName name) {
        return getO(String.format("%s-%s", name.serviceName(), name.appName()));
    }

    public Option<AppAccess> getDefault() {
        return getO("default");
    }

    @Override
    public void awaitInitialization() {
        super.awaitInitialization();
    }


    private AppAccess getOrCreate(String app) {
        return getO(app).getOrElse(() -> AppAccess.empty(app));
    }

    public void update(String app, Consumer<AppAccess> op) {
        AppAccess access = getOrCreate(app);
        op.accept(access);
        put(access);
    }

}
