package ru.yandex.chemodan.boot.admin.idm;

import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.misc.version.AppName;

/**
 * @author swined
 */
@Configuration
@Import({
        ChemodanCommonContextConfiguration.class,
        IdmInterceptorContextConfiguration.class,
        IdmAppsRegistryContextConfiguration.class
})
public class DefaultIdmInterceptorContextConfiguration {

    @Bean
    public IdmInterceptorConfig idmInterceptorConfig(AppName name, AppsRegistry registry) {
        Supplier<AppAccess> app = () -> registry.get(name).orElse(registry::getDefault).get();
        return new IdmInterceptorConfig(
                () -> app.get().getDefaultRoles(),
                path -> app
                        .get()
                        .getRoleMap()
                        .filterKeys(path::startsWith)
                        .values()
                        .reduceLeftO((a, b) -> Stream.of(a, b).flatMap(Set::stream).collect(Collectors.toSet()))
        );
    }

}
