package ru.yandex.chemodan.boot.admin.idm;

import java.util.Collections;
import java.util.Set;

import lombok.AllArgsConstructor;
import org.jetbrains.annotations.NotNull;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author friendlyevil
 */
@AllArgsConstructor
public class IdmAdminRolesService {
    private static final Logger logger = LoggerFactory.getLogger(IdmInterceptor.class);
    public static final String ROLES_ATTRIBUTE_NAME = "IDM_ROLES";

    private final AppName appName;
    private final UsersRegistry registry;

    public boolean check(Option<String> login, Set<String> requiredRoles) {
        return checkAndSetAttribute(login, requiredRoles, Option.empty());
    }

    public boolean check(Option<String> login, Set<String> requiredRoles, HttpServletRequestX req) {
        return checkAndSetAttribute(login, requiredRoles, Option.of(req));
    }

    private boolean checkAndSetAttribute(Option<String> login, Set<String> requiredRoles,
                                         Option<HttpServletRequestX> reqO) {
        Set<String> available = getUserRoles(login);
        reqO.ifPresent(req -> req.setAttribute(ROLES_ATTRIBUTE_NAME, available));

        boolean access = available.contains("SUPER") || available.containsAll(requiredRoles);
        logger.debug(String.format("access for login=%s available=%s required=%s : %s",
                login, available, requiredRoles, access ? "granted" : "denied"));
        return access;
    }

    @NotNull
    private Set<String> getUserRoles(Option<String> login) {
        return login
                .filterMap(registry::getO)
                .filterMap(ua -> ua.getAppAccess(appName))
                .orElseGet(Collections::emptySet);
    }

    public static Set<String> getRoles(HttpServletRequestX req) {
        return Option.ofNullable(req.getAttribute(ROLES_ATTRIBUTE_NAME))
                .map(roles -> (Set<String>) roles).orElseGet(Cf::set);
    }
}
