package ru.yandex.chemodan.boot.admin.idm;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author swined
 */
@Configuration
public class IdmAppsRegistryContextConfiguration {

    @Bean
    public AppsRegistry appsRegistry(@Qualifier("zkAllRoot") ZkPath zkRoot, ZkManager zkManager) {
        AppsRegistry registry = new AppsRegistry(zkRoot.child("idmapi-apps"));
        zkManager.addClient(registry);
        return registry;
    }
}
