package ru.yandex.chemodan.boot.admin.idm;

import java.util.Set;
import java.util.stream.Collectors;

import lombok.AllArgsConstructor;
import lombok.ToString;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.auth.YateamAuthUtils;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.commune.a3.action.result.error.ErrorResult;
import ru.yandex.commune.a3.utils.Ordered;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author swined
 */
@AllArgsConstructor
@ToString
public class IdmInterceptor implements ActionInvocationInterceptor {
    private final AppName appName;
    private final IdmInterceptorConfig config;
    private final IdmAdminRolesService idmAdminRolesService;

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        HttpServletRequestX request = invocation.getWebRequest().getHttpServletRequest();
        Option<String> login = YateamAuthUtils.getLoginFromAttributeO(request);

        if (login.isEmpty()) {
            return new ErrorResult("Access denied", "No authorization in request");
        }

        Set<String> required = getRequiredRoles(request);
        boolean access = idmAdminRolesService.check(login, required, request);

        if (!access) {
            Set<String> availableRoles = IdmAdminRolesService.getRoles(request);
            return new ErrorResult("Access denied", "Missing roles: "
                    + required.stream().filter(role -> !availableRoles.contains(role))
                    .collect(Collectors.joining(", ")));
        }

        return invocation.invoke();
    }

    private Set<String> getRequiredRoles(HttpServletRequestX request) {
        return request
                .getPathInfoO()
                .filterMap(config.getActionAccess())
                .orElseGet(config.getDefaultAccess());
    }

    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }
}
