package ru.yandex.chemodan.boot.admin.idm;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.blackbox.BlackboxAuthHelper;
import ru.yandex.chemodan.blackbox.BlackboxAuthInterceptor;
import ru.yandex.chemodan.blackbox.YtBlackboxContextConfiguration;
import ru.yandex.chemodan.boot.admin.CustomAdminActionInterceptorsHolder;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.version.AppName;

/**
 * @author swined
 */
@Configuration
@Import({IdmUsersRegistryContextConfiguration.class, YtBlackboxContextConfiguration.class})
public class IdmInterceptorContextConfiguration {

    @Autowired(required = false)
    private UsersRegistry registry;

    @Bean
    public IdmAdminRolesService idmAdminRolesService(AppName app) {
        return new IdmAdminRolesService(app, registry);
    }

    @Bean
    public CustomAdminActionInterceptorsHolder idmInterceptorHolder(
            AppName app,
            IdmInterceptorConfig config,
            IdmAdminRolesService idmAdminRolesService,
            BlackboxAuthHelper ytBlackboxHelper,
            @Value("${admin.yateam.allow.non_authorized:-true}") boolean allowNonAuthorized,
            @Value("${admin.idm.enabled:-true}") boolean idmEnabled) {
        if (idmEnabled) {
            Validate.notNull(registry, "Admin idm enabled, but no Users registry defined");
        }
        ListF<ActionInvocationInterceptor> interceptors = Cf.arrayList();

        if (!allowNonAuthorized) {
            interceptors.add(new BlackboxAuthInterceptor(ytBlackboxHelper));
        }

        if (!allowNonAuthorized && idmEnabled) {
            interceptors.add(new IdmInterceptor(app, config, idmAdminRolesService));
        }

        return () -> interceptors;
    }

}
