package ru.yandex.chemodan.boot.admin.idm;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author swined
 */
@Configuration
public class IdmUsersRegistryContextConfiguration {

    @Bean
    public UsersRegistry usersRegistry(@Qualifier("zkAllRoot") ZkPath zkRoot, ZkManager zkManager) {
        UsersRegistry registry = new UsersRegistry(zkRoot.child("idmapi-users"));
        registry.addAsClient(zkManager);
        return registry;
    }
}
