package ru.yandex.chemodan.boot.admin.idm;

import java.util.Collections;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.ToString;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.util.idm.RoleSpecification;
import ru.yandex.chemodan.util.idm.UserRoles;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.version.AppName;

/**
 * @author swined
 */
@BenderBindAllFields
@ToString
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public class UserAccess {

    private final String login;
    private final MapF<String, Set<String>> roles;

    public static UserAccess empty(String login) {
        return new UserAccess(login, Cf.map());
    }

    public String getLogin() {
        return login;
    }

    public Option<Set<String>> getAppAccess(AppName app) {
        return roles.getO(String.format("%s-%s", app.serviceName(), app.appName()));
    }

    public UserRoles getUserRoles(BiFunction<String, String, RoleSpecification> mapper) {
        return new UserRoles(login, roles.entries().flatMap(t -> t._2.stream().map(x -> mapper.apply(t._1, x)).collect(Collectors.toList())));
    }

    public UserAccess update(String app, String role, BiFunction<SetF<String>, String, SetF<String>> func) {
        return new UserAccess(login, roles.plus1(app, func.apply(Cf.toSet(roles.getOrElse(app, Collections.emptySet())), role)));
    }

    public UserAccess remapRoles(UnaryOperator<String> mapper) {
        return new UserAccess(login, roles.mapValues(r -> r.stream().map(mapper).collect(Collectors.toSet())));
    }

    public MapF<String, Set<String>> getRoles() {
        return roles.mapValues(Collections::unmodifiableSet).unmodifiable();
    }
}
