package ru.yandex.chemodan.boot.admin.idm;

import java.util.function.UnaryOperator;

import ru.yandex.bolts.function.Function;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.SynchronizedZkRegistry;
import ru.yandex.misc.bender.BenderMapper;

/**
 * @author swined
 */
public class UsersRegistry extends SynchronizedZkRegistry<String, UserAccess> {

    public UsersRegistry(ZkPath path) {
        super(
                path,
                new BenderMapper().createParserSerializer(UserAccess.class),
                UserAccess::getLogin,
                Function.identityF()
        );
    }

    private UserAccess getOrCreate(String user) {
        return getO(user).getOrElse(() -> UserAccess.empty(user));
    }

    public void update(String user, UnaryOperator<UserAccess> op) {
        doSynchronized(() -> put(op.apply(getOrCreate(user))));
    }


}
