package ru.yandex.chemodan.cache;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;

/**
 * @author eoshch
 */
public class CacheBuilderX<K, V> {
    private final CacheBuilder<K, V> builder;

    private CacheBuilderX(CacheBuilder<K, V> builder) {
        this.builder = builder;
    }

    public CacheBuilderX<K, V> expireAfterWrite(long duration, TimeUnit unit) {
        this.builder.expireAfterWrite(duration, unit);
        return this;
    }

    public CacheBuilderX<K, V> expireAfterAccess(long duration, TimeUnit unit) {
        this.builder.expireAfterAccess(duration, unit);
        return this;
    }

    public  CacheBuilderX<K, V> maximumSize(int size) {
        this.builder.maximumSize(size);
        return this;
    }

    public <K1 extends K, V1 extends V> LoadingCacheX<K1, V1> build(Function<K1, CacheableResult<V1>> function) {
        return new LoadingCacheX<>(builder.build(CacheLoader.from((K1 x) -> function.apply(x).getOrThrow())));
    }

    public static CacheBuilderX<Object, Object> newBuilder() {
        return new CacheBuilderX<>(CacheBuilder.newBuilder());
    }
}
