package ru.yandex.chemodan.cache;


import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;

/**
 * @author eoshch
 */
public class CacheableResult<V> {
    private Option<Tuple2<V, Boolean>> result;

    private CacheableResult(Option<Tuple2<V, Boolean>> result) {
        this.result = result;
    }

    public boolean isCached() {
        return result.exists(Tuple2::get2);
    }

    public Option<V> getValue() {
        return result.map(Tuple2::get1);
    }

    public V getOrThrow() {
        Tuple2<V, Boolean> tuple = result.getOrThrow(DoNotCacheException::new);
        if (!tuple._2) {
            throw new DoNotCacheException(Option.of(tuple._1));
        }
        return tuple._1;
    }

    public static <V> CacheableResult<V> cache(V value) {
        return new CacheableResult<>(Option.of(Tuple2.tuple(value, true)));
    }

    public static <V> CacheableResult<V> doNotCache() {
        return new CacheableResult<>(Option.empty());
    }

    public static <V> CacheableResult<V> doNotCache(V value) {
        return new CacheableResult<>(Option.of(Tuple2.tuple(value, false)));
    }

    public static <V> CacheableResult<V> cacheIfPresent(Option<V> value) {
        return value.map(CacheableResult::cache).getOrElse(CacheableResult::doNotCache);
    }
}
